// Common Audio Script.

var Audio = new Object;

/*
	The Audio object 'stolen' from the system script. Of course it could have
	been expanded on from there; but I wanted to write my own for some odd ball
	reason. Reinventing the wheel I suppose... Yawn...
*/

MusicVolume = 230;
SoundVolume = 170;
MusicPitch = 1;

with (Audio)
{
  Music = undefined;
  BGMusic = undefined;
  Sounds = [];
  CurrentSound = 0;
  Pitch = 1;
}


function ChangeMusic(name, repeat)
{
	if (repeat == undefined) repeat = true;
  with (Audio)
  {
    if (Music != undefined) Music.stop();
    Music = name;
    Music.setPitch(MusicPitch);
    Music.setVolume(MusicVolume);
    Music.play(repeat);
  }
}

function StopMusic()
{
	with (Audio) Music.stop();
}

function PlayBGMusic(name)
{
  with (Audio)
  {
    if (Music != undefined) Music.stop();
    if (name.length != 0)
    {
      BGMusic = LoadSound(name);
      BGName  = name;
      BGMusic.play(true);
    }
  }
}

function StopBGMusic()
{
		with (Audio) BGMusic.stop();
}

function PlaySound(name, queue)
{
	if(volume == undefined) volume = 255;
  with (Audio)
  {
    if (Sounds[CurrentSound] != undefined)
    {
      Sounds[CurrentSound].stop();
		}
    
    // use new one
    Sounds[CurrentSound] = name;
    Sounds[CurrentSound].setVolume(SoundVolume);
    Sounds[CurrentSound].setPitch(Pitch);
    Sounds[CurrentSound].play(false);
  
    // go to the next sound
    if (!queue)
    {
			CurrentSound++;
			if (CurrentSound >= 16)
			{
				CurrentSound = 0;
			}
    }
  }
}

function SetPitch(num)
{
	with(Audio)
	{
		Pitch = num;
	}
}

/*
	Music fade in function, used to fade the sound in over a period of time.
	Too bad it's stuck in blocking code... :/
*/

function FadeMusicIn(miliseconds,volume)
{
	if (volume == undefined) volume = 255;
	with (Audio) // Yep. Make sure this is the object.
	{
		var vol = Music.getVolume();
		var time = GetTime();
		while (GetTime() - time < miliseconds)
		{
			if (IsMapEngineRunning())
			{
				UpdateMapEngine();
				RenderMap();
				FlipScreen();
			}
			if (Music.getVolume() <= 255) // just so the volume doesn't equal 355 or 280...etc.
			{
				Music.setVolume(vol + (GetTime() - time) * volume / miliseconds);
			}
		}
	}
}

/*
	Music fade out function, used to fade the sound out over a period of time.
	Too bad it's stuck in blocking code... :/
*/

function FadeMusicOut(miliseconds,volume) // volume is to dynamically lower the volume,
{																					// instead of lowering it to 0, but to a value.
	if (volume == undefined) volume = 0;
	with (Audio) // I made this object for this purpose, there is a similar system script too...
	{
		var time = GetTime();
		while (GetTime() - time < miliseconds)
		{
			if (IsMapEngineRunning())
			{
				UpdateMapEngine();
				RenderMap();
				FlipScreen();
			}
			Music.setVolume(255 - (GetTime() - time) * volume / miliseconds);
		}
	}
}

/*
	Sound Emitting, based on area. It's position is reletive to
	the entity that controls it.
*/

Emitters = []; // A way to make more than 1 Emiter.

/*
	The name param, is used to direct who the reletive positions belong to.
	Of course it would be the controlling entity, but it can also switch
	the sound to another entity other than itself by changing the param.
	
	Since this will draw from a sound file that may be used in more than
	1 location I also need to create a buffer zone to stop the sounds playing.
	This is because, regardless of the emmiter amount, sound.stop will stop
	that sound, no matter what emmiter calls that. So I'll only allow it in
	a buffer zone so the same sound elsewhere can play.
*/

var distance = 0;

function EmitSound(sound,x,y,w,h,name)
{
	if (name == undefined ) name = GetCurrentPerson();
	x = GetPersonX(name) + x;
	y = GetPersonY(name) + y;
	if (Player.x > x && Player.y > y && Player.x < x+w && Player.y < y+h)
	{
		if (!sound.isPlaying()) sound.play(true);
		distance = Math.sqrt(Math.pow(Player.x-GetPersonX(name),2) + Math.pow(Player.y-GetPersonY(name),2));
		sound.setVolume(255-distance);
	}
	else
	{
		if (Player.x > x-8 && Player.y > y-8 && Player.x < x+w+16 && Player.y < y+h+16) // buffer by 8px
		{
			if (sound.isPlaying()) sound.stop();
		}
	}
}

var CurrentSong = 0;
var SongList = [];
SongList[0] = LoadSound('hyo-dream.it');
SongList[1] = LoadSound('hyo-heroic.it');
SongList[2] = LoadSound('hyo-fate.it');
SongList[3] = LoadSound('hyo-tears.it');
SongList[4] = LoadSound('hyo-bea.it');
SongList[5] = LoadSound('hyo-euro.it');
SongList[6] = LoadSound('hyo-wpeace.it');
var TitleList = []
TitleList[0] = "Forever Dream";
TitleList[1] = "Heroic";
TitleList[2] = "Fate";
TitleList[3] = "Tears";
TitleList[4] = "Beautiful";
TitleList[5] = "Euro Instrumental";
TitleList[6] = "World Peace";
function PlaySongList()
{
	with(Audio)
	{
		if (!Music.isPlaying())
		{
			CurrentSong = Math.floor(Math.random()*7);
			ChangeMusic(SongList[CurrentSong], false);
			SongTicks = 200;
		}
	}
}

var SongTicks = 200;
function DrawCurrentSong()
{
	if (SongTicks > 0)
	{
		font.drawText(0, SH-21, "Now Playing: \"" + TitleList[CurrentSong] + "\"");
		SongTicks--;
	}
}